/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeParameter;

public class TypeParameterPrologConverter
extends NodeConverter<TypeParameter> {
    private static final String KEY = "type_parameter";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[8];
        stringArray[1] = "parent";
        stringArray[3] = "modifiers";
        stringArray[4] = "bounds";
        stringArray[5] = "body_declaration";
        stringArray[6] = "type_declaration";
        stringArray[7] = "compilation_unit";
        KEYS = stringArray;
    }

    public TypeParameterPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(TypeParameter node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String parent = this.mapper.getNodeID(node.getParent());
        String name = this.quote(node.getName().getIdentifier());
        Vector modifiers_nodes = new Vector();
        modifiers_nodes.addAll(node.modifiers());
        Vector<String> modifiers_names = new Vector<String>();
        for (IExtendedModifier modifier : modifiers_nodes) {
            if (!modifier.isModifier()) continue;
            modifiers_names.add(this.quote(((Modifier)modifier).getKeyword().toString()));
        }
        String modifiers = modifiers_names.toString();
        Vector<ASTNode> types_bounds_nodes = new Vector<ASTNode>();
        types_bounds_nodes.addAll(node.typeBounds());
        for (ASTNode type_bound : types_bounds_nodes) {
            this.converter_factory.getConverter(type_bound).convert(type_bound);
        }
        String types_bounds = this.generateList(types_bounds_nodes);
        String body_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node));
        String type_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node).getParent());
        String unit = this.mapper.getNodeID(node.getRoot());
        String[] args = new String[]{id, parent, name, modifiers, types_bounds, body_declaration, type_declaration, unit};
        this.code.addFact(KEY, this.generateArgs(KEYS, args));
    }

    @Override
    public void bind(TypeParameter node) {
        this.mapper.setBindingID((IBinding)node.resolveBinding(), this.mapper.getNodeID((ASTNode)node));
        this.mapper.setParent((ASTNode)node, this.mapper.getParent(node.getParent()));
        Vector types_bounds_nodes = new Vector();
        types_bounds_nodes.addAll(node.typeBounds());
        for (ASTNode type_bound : types_bounds_nodes) {
            this.converter_factory.getConverter(type_bound).bind(type_bound);
        }
    }
}

