/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;

public class SingleVariableDeclarationPrologConverter
extends NodeConverter<SingleVariableDeclaration> {
    private static final String KEY = "variable_declaration";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[10];
        stringArray[1] = "parent";
        stringArray[3] = "type";
        stringArray[4] = "modifiers";
        stringArray[5] = "extra_dimensions";
        stringArray[6] = "initializer";
        stringArray[7] = "body_declaration";
        stringArray[8] = "type_declaration";
        stringArray[9] = "compilation_unit";
        KEYS = stringArray;
    }

    public SingleVariableDeclarationPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(SingleVariableDeclaration node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String parent = this.mapper.getNodeID(node.getParent());
        String name = this.quote(node.getName().getIdentifier());
        this.converter_factory.getConverter((ASTNode)node.getType()).convert(node.getType());
        String type = this.mapper.getNodeID((ASTNode)node.getType());
        Vector modifiers_nodes = new Vector();
        modifiers_nodes.addAll(node.modifiers());
        Vector<String> modifiers_names = new Vector<String>();
        for (IExtendedModifier modifier : modifiers_nodes) {
            if (!modifier.isModifier()) continue;
            modifiers_names.add(this.quote(((Modifier)modifier).getKeyword().toString()));
        }
        String modifiers = modifiers_names.toString();
        String dimensions = Integer.toString(node.getExtraDimensions());
        String initializer = null;
        if (node.getInitializer() != null) {
            initializer = this.mapper.getNodeID((ASTNode)node.getInitializer());
        }
        String body_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node));
        String type_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node).getParent());
        String unit = this.mapper.getNodeID(node.getRoot());
        String[] args = new String[]{id, parent, name, type, modifiers, dimensions, initializer, body_declaration, type_declaration, unit};
        this.code.addFact(KEY, this.generateArgs(KEYS, args));
    }

    @Override
    public void bind(SingleVariableDeclaration node) {
        this.mapper.setBindingID((IBinding)node.resolveBinding(), this.mapper.getNodeID((ASTNode)node));
        this.mapper.setParent((ASTNode)node, this.mapper.getParent(node.getParent()));
        this.converter_factory.getConverter((ASTNode)node.getType()).bind(node.getType());
        if (node.getInitializer() != null) {
            this.converter_factory.getConverter((ASTNode)node.getInitializer()).bind(node.getInitializer());
        }
    }
}

