/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Modifier;

public class InitializerPrologConverter
extends NodeConverter<Initializer> {
    private static final String KEY = "initializer";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[5];
        stringArray[1] = "parent";
        stringArray[2] = "modifiers";
        stringArray[3] = "body";
        stringArray[4] = "compilation_unit";
        KEYS = stringArray;
    }

    public InitializerPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(Initializer node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String parent = this.mapper.getNodeID(node.getParent());
        Vector modifiers_nodes = new Vector();
        modifiers_nodes.addAll(node.modifiers());
        Vector<String> modifiers_names = new Vector<String>();
        for (IExtendedModifier modifier : modifiers_nodes) {
            if (!modifier.isModifier()) continue;
            modifiers_names.add(this.quote(((Modifier)modifier).getKeyword().toString()));
        }
        String modifiers = modifiers_names.toString();
        this.converter_factory.getConverter((ASTNode)node.getBody()).convert(node.getBody());
        String body = this.mapper.getNodeID((ASTNode)node.getBody());
        String unit = this.mapper.getNodeID(node.getRoot());
        String[] args = new String[]{id, parent, modifiers, body, unit};
        this.code.addFact(KEY, this.generateArgs(KEYS, args));
    }

    @Override
    public void bind(Initializer node) {
        this.mapper.getNodeID((ASTNode)node);
        this.mapper.setParent((ASTNode)node, (ASTNode)node);
        this.converter_factory.getConverter((ASTNode)node.getBody()).bind(node.getBody());
    }
}

