/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ImportDeclaration;

public class ImportDeclarationPrologConverter
extends NodeConverter<ImportDeclaration> {
    private static final String KEY = "import_declaration";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[5];
        stringArray[1] = "parent";
        stringArray[2] = "fqn";
        stringArray[3] = "on_demand";
        stringArray[4] = "static";
        KEYS = stringArray;
    }

    public ImportDeclarationPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(ImportDeclaration node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String parent = this.mapper.getNodeID(node.getParent());
        String fqn = this.quote(node.getName().getFullyQualifiedName().toString());
        String is_on_demand = Boolean.toString(node.isOnDemand());
        String is_static = Boolean.toString(node.isStatic());
        String[] args = new String[]{id, parent, fqn, is_on_demand, is_static};
        this.code.addFact(KEY, this.generateArgs(KEYS, args));
    }

    @Override
    public void bind(ImportDeclaration node) {
        this.mapper.getNodeID((ASTNode)node);
        this.mapper.setParent((ASTNode)node, this.mapper.getParent(node.getParent()));
    }
}

