/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayCreation;

public class ArrayCreationPrologConverter
extends NodeConverter<ArrayCreation> {
    private static final String KEY = "array_creation";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[8];
        stringArray[1] = "parent";
        stringArray[2] = "type";
        stringArray[3] = "dimensions";
        stringArray[4] = "initializer";
        stringArray[5] = "body_declaration";
        stringArray[6] = "type_declaration";
        stringArray[7] = "compilation_unit";
        KEYS = stringArray;
    }

    protected ArrayCreationPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(ArrayCreation node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String parent = this.mapper.getNodeID(node.getParent());
        this.converter_factory.getConverter((ASTNode)node.getType()).convert(node.getType());
        String type = this.mapper.getNodeID((ASTNode)node.getType());
        Vector<ASTNode> expressions_nodes = new Vector<ASTNode>();
        expressions_nodes.addAll(node.dimensions());
        for (ASTNode expression : expressions_nodes) {
            this.converter_factory.getConverter(expression).convert(expression);
        }
        String expressions = this.generateList(expressions_nodes);
        String initializer = null;
        if (node.getInitializer() != null) {
            this.converter_factory.getConverter((ASTNode)node.getInitializer()).convert(node.getInitializer());
            initializer = this.mapper.getNodeID((ASTNode)node.getInitializer());
        }
        String body_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node));
        String type_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node).getParent());
        String unit = this.mapper.getNodeID(node.getRoot());
        String[] args = new String[]{id, parent, type, expressions, initializer, body_declaration, type_declaration, unit};
        this.code.addFact(KEY, this.generateArgs(KEYS, args));
    }

    @Override
    public void bind(ArrayCreation node) {
        this.mapper.getNodeID((ASTNode)node);
        this.mapper.setParent((ASTNode)node, this.mapper.getParent(node.getParent()));
        this.converter_factory.getConverter((ASTNode)node.getType()).bind(node.getType());
        Vector expressions_nodes = new Vector();
        expressions_nodes.addAll(node.dimensions());
        for (ASTNode expression : expressions_nodes) {
            this.converter_factory.getConverter(expression).bind(expression);
        }
        if (node.getInitializer() != null) {
            this.converter_factory.getConverter((ASTNode)node.getInitializer()).bind(node.getInitializer());
        }
    }
}

