/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class EnumDeclarationPrologConverter
extends NodeConverter<EnumDeclaration> {
    private static final String KEY = "enum_declaration";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[8];
        stringArray[1] = "parent";
        stringArray[3] = "modifiers";
        stringArray[4] = "implements";
        stringArray[5] = "constants";
        stringArray[6] = "declarations";
        stringArray[7] = "compilation_unit";
        KEYS = stringArray;
    }

    public EnumDeclarationPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(EnumDeclaration node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String parent = this.mapper.getNodeID(node.getParent());
        String name = this.quote(node.getName().toString());
        Vector modifiers_nodes = new Vector();
        modifiers_nodes.addAll(node.modifiers());
        Vector<String> modifiers_names = new Vector<String>();
        for (IExtendedModifier modifier : modifiers_nodes) {
            if (!modifier.isModifier()) continue;
            modifiers_names.add(this.quote(((Modifier)modifier).getKeyword().toString()));
        }
        String modifiers = modifiers_names.toString();
        Vector<ASTNode> implements_nodes = new Vector<ASTNode>();
        implements_nodes.addAll(node.superInterfaceTypes());
        for (ASTNode implement : implements_nodes) {
            this.converter_factory.getConverter(implement).convert(implement);
        }
        String implements_ids = this.generateList(implements_nodes);
        Vector<ASTNode> enum_constants_nodes = new Vector<ASTNode>();
        enum_constants_nodes.addAll(node.enumConstants());
        for (ASTNode enum_constant : enum_constants_nodes) {
            this.converter_factory.getConverter(enum_constant).convert(enum_constant);
        }
        String enum_constants = this.generateList(enum_constants_nodes);
        Vector<ASTNode> declarations_nodes = new Vector<ASTNode>();
        declarations_nodes.addAll(node.bodyDeclarations());
        for (ASTNode declaration : declarations_nodes) {
            this.converter_factory.getConverter(declaration).convert(declaration);
        }
        String declarations = this.generateList(declarations_nodes);
        String unit = this.mapper.getNodeID(node.getRoot());
        String[] args = new String[]{id, parent, name, modifiers, implements_ids, enum_constants, declarations, unit};
        this.code.addFact(KEY, this.generateArgs(KEYS, args));
    }

    @Override
    public void bind(EnumDeclaration node) {
        this.mapper.setBindingID((IBinding)node.resolveBinding(), this.mapper.getNodeID((ASTNode)node));
        this.mapper.setParent((ASTNode)node, (ASTNode)node);
        Vector implements_nodes = new Vector();
        implements_nodes.addAll(node.superInterfaceTypes());
        for (ASTNode implement : implements_nodes) {
            this.converter_factory.getConverter(implement).bind(implement);
        }
        Vector enum_constants_nodes = new Vector();
        enum_constants_nodes.addAll(node.enumConstants());
        for (ASTNode enum_constant : enum_constants_nodes) {
            this.converter_factory.getConverter(enum_constant).bind(enum_constant);
        }
        Vector declarations_nodes = new Vector();
        declarations_nodes.addAll(node.bodyDeclarations());
        for (ASTNode declaration : declarations_nodes) {
            this.converter_factory.getConverter(declaration).bind(declaration);
        }
    }

    @Override
    public String getName(TypeDeclaration node) {
        return "enum " + node.getName().toString();
    }
}

