/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverter;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayInitializer;

public class ArrayInitializerPrologConverter
extends NodeConverter<ArrayInitializer> {
    private static final String KEY = "array_initializer";
    private static final String[] KEYS;

    static {
        String[] stringArray = new String[6];
        stringArray[1] = "parent";
        stringArray[2] = "expressions";
        stringArray[3] = "body_declaration";
        stringArray[4] = "type_declaration";
        stringArray[5] = "compilation_unit";
        KEYS = stringArray;
    }

    public ArrayInitializerPrologConverter(Mapper mapper, PrologCode code, NodeConverterFactory converter_factory) {
        super(mapper, code, converter_factory);
    }

    @Override
    public void convert(ArrayInitializer node) {
        String id = this.mapper.getNodeID((ASTNode)node);
        String parent = this.mapper.getNodeID(node.getParent());
        Vector<ASTNode> expressions_nodes = new Vector<ASTNode>();
        expressions_nodes.addAll(node.expressions());
        for (ASTNode expression : expressions_nodes) {
            this.converter_factory.getConverter(expression).convert(expression);
        }
        String expressions = this.generateList(expressions_nodes);
        String body_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node));
        String type_declaration = this.mapper.getNodeID(this.mapper.getParent((ASTNode)node).getParent());
        String unit = this.mapper.getNodeID(node.getRoot());
        String[] args = new String[]{id, parent, expressions, body_declaration, type_declaration, unit};
        this.code.addFact(KEY, this.generateArgs(KEYS, args));
    }

    @Override
    public void bind(ArrayInitializer node) {
        this.mapper.getNodeID((ASTNode)node);
        this.mapper.setParent((ASTNode)node, this.mapper.getParent(node.getParent()));
        Vector expressions_nodes = new Vector();
        expressions_nodes.addAll(node.expressions());
        for (ASTNode expression : expressions_nodes) {
            this.converter_factory.getConverter(expression).bind(expression);
        }
    }
}

