/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler;

import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.Mapper;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.PrologCode;
import ar.edu.unicen.isistan.si.teachingassistant.plugin.teacher.modeler.converters.NodeConverterFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class ModelGenerator {
    private static final String MONITOR_TITLE = "Traduciendo arbol sintactico";
    private PrologCode prologCode;
    private Mapper mapper;
    private NodeConverterFactory converterFactory;

    private void init() {
        this.prologCode = new PrologCode();
        this.mapper = new Mapper();
        this.converterFactory = new NodeConverterFactory(this.mapper, this.prologCode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int process(List<CompilationUnit> units, IProgressMonitor monitor) {
        this.init();
        try {
            monitor.beginTask(MONITOR_TITLE, units.size() * 2);
            for (CompilationUnit unit : units) {
                this.converterFactory.getConverter((ASTNode)unit).bind(unit);
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                monitor.done();
                return 1;
            }
            for (CompilationUnit unit : units) {
                this.converterFactory.getConverter((ASTNode)unit).convert(unit);
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                monitor.done();
                return 1;
            }
            return 0;
        }
        catch (Exception exception) {
            monitor.done();
            return -1;
        }
    }

    public PrologCode getPrologCode() {
        return this.prologCode;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public NodeConverterFactory getFactory() {
        return this.converterFactory;
    }

    public ArrayList<String> toRepresentation() {
        return this.prologCode.getFacts();
    }
}

